/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nways.cfgman;

import com.ibm.nways.cfgman.CfgManService;
import com.ibm.nways.cfgman.DbObject;
import com.ibm.nways.cfgman.JobDataSource;
import com.ibm.nways.cfgman.JobDispatcher;
import com.ibm.nways.cfgman.JobTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import jclass.table3.TableData;

public class Job
extends DbObject {
    transient JobTable jobTable;
    public int jobId;
    public String jobType;
    public Timestamp earliestStart;
    public Timestamp latestStart;
    public String status;
    public Timestamp startedAt;
    public Timestamp finishedAt;
    public String createdBy;
    public Timestamp createdAt;
    public int predecessor = -1;
    public String results;
    public static final String Scheduled = "scheduled";
    public static final String Running = "running";
    public static final String Stopped = "stopped";
    public static final String Finished = "finished";
    public static final int JobTypeMaxLen = 32;
    public static final int ResultsMaxLen = 100;

    public Job() {
    }

    public Job(CfgManService cfgManService) {
        this.setCfgManService(cfgManService);
    }

    public void setCfgManService(CfgManService cfgManService) {
        super.setCfgManService(cfgManService);
        this.jobTable = this.dbManager.jobTable;
    }

    public void insert(boolean bl) throws SQLException {
        this.jobId = this.dbManager.globalTable.nextJobId(true);
        this.jobTable.add(this);
    }

    public boolean get(boolean bl) throws SQLException {
        return this.jobTable.get(this);
    }

    public int update(boolean bl) throws SQLException {
        return this.jobTable.update(this);
    }

    public int updateEditable(boolean bl) throws SQLException {
        return this.jobTable.updateEditable(this);
    }

    public int restart(boolean bl) throws SQLException {
        return this.jobTable.restart(this);
    }

    public int delete(boolean bl) throws SQLException {
        int n = this.jobTable.delete(this);
        this.deleteLogFile();
        return n;
    }

    public void applyUserEditableChanges(Job job) {
        this.earliestStart = job.earliestStart;
        this.latestStart = job.latestStart;
        this.predecessor = job.predecessor;
    }

    public void wakeupDispatcher() {
        JobDispatcher jobDispatcher = this.cfgManSvc.getJobDispatcher();
        if (jobDispatcher != null) {
            jobDispatcher.wakeup();
        }
    }

    public String toString() {
        return "[" + this.toString2() + "]";
    }

    protected String toString2() {
        return String.valueOf(this.jobId) + ", " + this.jobType + ", " + this.earliestStart + ", " + this.latestStart + ", " + this.status + ", " + this.startedAt + ", " + this.finishedAt + ", " + this.createdBy + ", " + this.createdAt + ", " + this.predecessor + ", " + this.results;
    }

    public TableData getDataSource() {
        return new JobDataSource(this);
    }

    public File getLogFile() {
        File file = this.cfgManSvc.getLogDirectory();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, "Job" + String.valueOf(this.jobId) + ".log");
        return file2;
    }

    public void deleteLogFile() {
        File file = this.getLogFile();
        if (file != null) {
            file.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getLogString() {
        String string = null;
        File file = this.getLogFile();
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                int n;
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                while ((n = bufferedReader.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                string = stringBuffer.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object var7_10 = null;
            if (bufferedReader == null) return string;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }
}

